set more off 
pause off
set logtype text
set mem 500M

*************** DESCRIPTION *************************************
* Loads entry/exit information by SIC code and aggregates to total
*
*	Input: 		0.raw_inputs\bds_f_sic_release.csv
*	Output: 	2.intermediate\entry_out
*
*****************************************************************

* Entry/exit rates
import delimited 0.raw_inputs\bds_f_sic_release.csv, clear

g a1_logN_bds = log(estabs)

* Compute aggregate entry rate
egen a_estabs = sum(estabs), by(year)
egen a_estabs_entry = sum(estabs_entry), by(year)
egen a_estabs_exit = sum(estabs_exit), by(year)

g a_entry_bds = a_estabs_entry / a_estabs
g a_exit_bds = a_estabs_exit/a_estabs
g a_logN_bds = log(a_estabs)

rename year2 year
bys year : keep if _n ==1 
keep year a_*

compress
save 2.intermediate\entry_out, replace
